package ObserverEsercizio;

import java.util.ArrayList;
import java.util.List;

//Subject che implementa l'aggiunta, la rimozione e la notifica degli osservatori
class WeatherStation {
 private List<Observer> observers = new ArrayList<>();
 private List<Observer> temperatureObservers = new ArrayList<>();
 private float temperature;
 private float humidity;
 private float pressure;

 public void addObserver(Observer observer) {
     observers.add(observer);
 }

 public void removeObserver(Observer observer) {
     observers.remove(observer);
 }

 
 public void addTemperatureObserver(Observer observer) {
     temperatureObservers.add(observer);
 }

 public void removeTemperatureObserver(Observer observer) {
     temperatureObservers.remove(observer);
 }
 public void notifyObservers() {
     for (Observer observer : observers) {
         observer.update(temperature, humidity, pressure);
     }
 }

 public void notifyTemperatureObservers() {
     for (Observer observer : temperatureObservers) {
         observer.updateTemperature(temperature);
     }
 }
 public void setMeasurements(float temperature, float humidity, float pressure) {
     this.temperature = temperature;
     this.humidity = humidity;
     this.pressure = pressure;
     notifyObservers();
     notifyTemperatureObservers();
 }
 
 	public void setTemperature(float temperature) {
 		this.temperature=temperature;
 		notifyTemperatureObservers();
 		
 	}
}

